#ifndef GST_MOMAPROPERTYVALUE_H
#define GST_MOMAPROPERTYVALUE_H

#include <Client/ClientUtils/MoMaPropertyDesc.h>
#include <Client/ClientUtils/Network/NetworkInterfaceStructs.h>
#include <Geometry/IGeometry.h>
#include <buildspec.h>
#include <config.h>

#include <boost/shared_ptr.hpp>
#include <boost/variant.hpp>

#include <string>
#include <vector>

using GST::ClientUtils::MoMaPropertyDesc;
using GST::ClientUtils::MoMaPropertyDescPtr;

namespace GST
{
namespace ClientUtils
{
class GST_API_EXPORT MoMaPropertyValue : public ConstrainedTableAttributeVal
{
public:
private:
	MoMaPropertyDescPtr desc;
	LinkedElementPtr linkedElement;

public:
	MoMaPropertyValue();
	MoMaPropertyValue(const MoMaPropertyValue &other);
	MoMaPropertyValue(const TableAttributeValPtr val,
					  MoMaPropertyDescPtr _desc,
					  LinkedElementPtr _element);
	TableAttributeDesc::DType getDType() const;
	MoMaPropertyDescPtr getMoMaPropertyDesc() const;
	LinkedElementPtr getLinkedElement() const;
	void setValue(const TableAttributeValPtr newvalue);
	MoMaPropertyDesc::PROPERTYID getDescId() const;
	LinkAdjacency::LinkId getLinkedElementId() const;
	~MoMaPropertyValue();
};

typedef boost::shared_ptr<MoMaPropertyValue> MoMaPropertyValuePtr;
typedef std::vector<MoMaPropertyValuePtr> MoMaPropertyValueList;
typedef boost::shared_ptr<MoMaPropertyValueList> MoMaPropertyValueListPtr;

} // namespace ClientUtils
} // namespace GST

#endif // GST_MOMAPROPERTYVALUE_H
